/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.org.bson.codecs;

import java.util.HashMap;
import java.util.Map;
import net.impactdev.impactor.relocations.org.bson.BsonArray;
import net.impactdev.impactor.relocations.org.bson.BsonBinary;
import net.impactdev.impactor.relocations.org.bson.BsonBoolean;
import net.impactdev.impactor.relocations.org.bson.BsonDateTime;
import net.impactdev.impactor.relocations.org.bson.BsonDbPointer;
import net.impactdev.impactor.relocations.org.bson.BsonDecimal128;
import net.impactdev.impactor.relocations.org.bson.BsonDocument;
import net.impactdev.impactor.relocations.org.bson.BsonDocumentWrapper;
import net.impactdev.impactor.relocations.org.bson.BsonDouble;
import net.impactdev.impactor.relocations.org.bson.BsonInt32;
import net.impactdev.impactor.relocations.org.bson.BsonInt64;
import net.impactdev.impactor.relocations.org.bson.BsonJavaScript;
import net.impactdev.impactor.relocations.org.bson.BsonJavaScriptWithScope;
import net.impactdev.impactor.relocations.org.bson.BsonMaxKey;
import net.impactdev.impactor.relocations.org.bson.BsonMinKey;
import net.impactdev.impactor.relocations.org.bson.BsonNull;
import net.impactdev.impactor.relocations.org.bson.BsonObjectId;
import net.impactdev.impactor.relocations.org.bson.BsonRegularExpression;
import net.impactdev.impactor.relocations.org.bson.BsonString;
import net.impactdev.impactor.relocations.org.bson.BsonSymbol;
import net.impactdev.impactor.relocations.org.bson.BsonTimestamp;
import net.impactdev.impactor.relocations.org.bson.BsonType;
import net.impactdev.impactor.relocations.org.bson.BsonUndefined;
import net.impactdev.impactor.relocations.org.bson.BsonValue;
import net.impactdev.impactor.relocations.org.bson.RawBsonDocument;
import net.impactdev.impactor.relocations.org.bson.codecs.BsonArrayCodec;
import net.impactdev.impactor.relocations.org.bson.codecs.BsonBinaryCodec;
import net.impactdev.impactor.relocations.org.bson.codecs.BsonBooleanCodec;
import net.impactdev.impactor.relocations.org.bson.codecs.BsonDBPointerCodec;
import net.impactdev.impactor.relocations.org.bson.codecs.BsonDateTimeCodec;
import net.impactdev.impactor.relocations.org.bson.codecs.BsonDecimal128Codec;
import net.impactdev.impactor.relocations.org.bson.codecs.BsonDocumentCodec;
import net.impactdev.impactor.relocations.org.bson.codecs.BsonDocumentWrapperCodec;
import net.impactdev.impactor.relocations.org.bson.codecs.BsonDoubleCodec;
import net.impactdev.impactor.relocations.org.bson.codecs.BsonInt32Codec;
import net.impactdev.impactor.relocations.org.bson.codecs.BsonInt64Codec;
import net.impactdev.impactor.relocations.org.bson.codecs.BsonJavaScriptCodec;
import net.impactdev.impactor.relocations.org.bson.codecs.BsonJavaScriptWithScopeCodec;
import net.impactdev.impactor.relocations.org.bson.codecs.BsonMaxKeyCodec;
import net.impactdev.impactor.relocations.org.bson.codecs.BsonMinKeyCodec;
import net.impactdev.impactor.relocations.org.bson.codecs.BsonNullCodec;
import net.impactdev.impactor.relocations.org.bson.codecs.BsonObjectIdCodec;
import net.impactdev.impactor.relocations.org.bson.codecs.BsonRegularExpressionCodec;
import net.impactdev.impactor.relocations.org.bson.codecs.BsonStringCodec;
import net.impactdev.impactor.relocations.org.bson.codecs.BsonSymbolCodec;
import net.impactdev.impactor.relocations.org.bson.codecs.BsonTimestampCodec;
import net.impactdev.impactor.relocations.org.bson.codecs.BsonTypeClassMap;
import net.impactdev.impactor.relocations.org.bson.codecs.BsonUndefinedCodec;
import net.impactdev.impactor.relocations.org.bson.codecs.BsonValueCodec;
import net.impactdev.impactor.relocations.org.bson.codecs.Codec;
import net.impactdev.impactor.relocations.org.bson.codecs.RawBsonDocumentCodec;
import net.impactdev.impactor.relocations.org.bson.codecs.configuration.CodecProvider;
import net.impactdev.impactor.relocations.org.bson.codecs.configuration.CodecRegistry;

public class BsonValueCodecProvider
implements CodecProvider {
    private static final BsonTypeClassMap DEFAULT_BSON_TYPE_CLASS_MAP;
    private final Map<Class<?>, Codec<?>> codecs = new HashMap();

    public BsonValueCodecProvider() {
        this.addCodecs();
    }

    public static Class<? extends BsonValue> getClassForBsonType(BsonType bsonType) {
        return DEFAULT_BSON_TYPE_CLASS_MAP.get(bsonType);
    }

    public static BsonTypeClassMap getBsonTypeClassMap() {
        return DEFAULT_BSON_TYPE_CLASS_MAP;
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        if (this.codecs.containsKey(clazz)) {
            return this.codecs.get(clazz);
        }
        if (clazz == BsonJavaScriptWithScope.class) {
            return new BsonJavaScriptWithScopeCodec(registry.get(BsonDocument.class));
        }
        if (clazz == BsonValue.class) {
            return new BsonValueCodec(registry);
        }
        if (clazz == BsonDocumentWrapper.class) {
            return new BsonDocumentWrapperCodec(registry.get(BsonDocument.class));
        }
        if (clazz == RawBsonDocument.class) {
            return new RawBsonDocumentCodec();
        }
        if (BsonDocument.class.isAssignableFrom(clazz)) {
            return new BsonDocumentCodec(registry);
        }
        if (BsonArray.class.isAssignableFrom(clazz)) {
            return new BsonArrayCodec(registry);
        }
        return null;
    }

    private void addCodecs() {
        this.addCodec(new BsonNullCodec());
        this.addCodec(new BsonBinaryCodec());
        this.addCodec(new BsonBooleanCodec());
        this.addCodec(new BsonDateTimeCodec());
        this.addCodec(new BsonDBPointerCodec());
        this.addCodec(new BsonDoubleCodec());
        this.addCodec(new BsonInt32Codec());
        this.addCodec(new BsonInt64Codec());
        this.addCodec(new BsonDecimal128Codec());
        this.addCodec(new BsonMinKeyCodec());
        this.addCodec(new BsonMaxKeyCodec());
        this.addCodec(new BsonJavaScriptCodec());
        this.addCodec(new BsonObjectIdCodec());
        this.addCodec(new BsonRegularExpressionCodec());
        this.addCodec(new BsonStringCodec());
        this.addCodec(new BsonSymbolCodec());
        this.addCodec(new BsonTimestampCodec());
        this.addCodec(new BsonUndefinedCodec());
    }

    private <T extends BsonValue> void addCodec(Codec<T> codec) {
        this.codecs.put(codec.getEncoderClass(), codec);
    }

    static {
        HashMap map = new HashMap();
        map.put(BsonType.NULL, BsonNull.class);
        map.put(BsonType.ARRAY, BsonArray.class);
        map.put(BsonType.BINARY, BsonBinary.class);
        map.put(BsonType.BOOLEAN, BsonBoolean.class);
        map.put(BsonType.DATE_TIME, BsonDateTime.class);
        map.put(BsonType.DB_POINTER, BsonDbPointer.class);
        map.put(BsonType.DOCUMENT, BsonDocument.class);
        map.put(BsonType.DOUBLE, BsonDouble.class);
        map.put(BsonType.INT32, BsonInt32.class);
        map.put(BsonType.INT64, BsonInt64.class);
        map.put(BsonType.DECIMAL128, BsonDecimal128.class);
        map.put(BsonType.MAX_KEY, BsonMaxKey.class);
        map.put(BsonType.MIN_KEY, BsonMinKey.class);
        map.put(BsonType.JAVASCRIPT, BsonJavaScript.class);
        map.put(BsonType.JAVASCRIPT_WITH_SCOPE, BsonJavaScriptWithScope.class);
        map.put(BsonType.OBJECT_ID, BsonObjectId.class);
        map.put(BsonType.REGULAR_EXPRESSION, BsonRegularExpression.class);
        map.put(BsonType.STRING, BsonString.class);
        map.put(BsonType.SYMBOL, BsonSymbol.class);
        map.put(BsonType.TIMESTAMP, BsonTimestamp.class);
        map.put(BsonType.UNDEFINED, BsonUndefined.class);
        DEFAULT_BSON_TYPE_CLASS_MAP = new BsonTypeClassMap(map);
    }
}

